/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBFooter = Object.create(STBModule.prototype);

STBFooter.name = "Footer";

STBFooter.updatePosition = function() {

    try {
        var body			= jQuery('body'),
            main			= jQuery("main"),
            footerHeight	= jQuery("footer").height(),
            winHeight		= window.innerHeight,
            wrapperHeight	= jQuery(".wrapper").height(),
            headerHeight	= wrapperHeight;

		if (body.attr("data-menu-over-title") == "true") {
			headerHeight = 0;
		} 

        main.css("min-height", "auto");

        if ((main.height() + headerHeight + footerHeight) < winHeight) {
            main.css("min-height", (winHeight - headerHeight - footerHeight));
        }

    } catch (e) {
        getStack(0, e);
    }
}

STBFooter.collapseClick = function() {
	if (jQuery('body').attr('data-footer-collapse') == 'true') {

		var widgets = jQuery(".widget" , "footer");

		if (widgets.length > 0 ){
			widgets.each(function(){
				var widget = jQuery(this),
					head = widget.find(".widget-head");

				if (head.length){
					widget.addClass("closed");

					head.click(function() {
						var el = jQuery(this);

						el.parent().toggleClass("closed");
					});

				}
			});
		}
	}		
}


STBFooter.runOnReady = function() {
	STBFooter.collapseClick();
}

STBFooter.runOnResize = function() {

}

STBFooter.runOnLoad = function() {

	if (!site.onepage) {
		STBFooter.updatePosition();
	}
}

site.registerModule(STBFooter);